/*******

MICE server

copyright 2001, 2002, Alan H. Clifford.

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your option)
any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc., 59
Temple Place, Suite 330, Boston, MA 02111-1307 USA


Alan Clifford can be contacted at mice@clifford.ac

Latest version at http://www.clifford.ac

$Id: mice.server.h,v 1.21 2002/06/21 23:24:16 alan Exp $
$Name: release4_2 $

*******/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/time.h>
#include <string.h>
#include <ctype.h>
#include <signal.h>
#include <sys/wait.h>
#include <errno.h>
#include <netdb.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <getopt.h>
#include <syslog.h>


typedef struct Params2 {
    unsigned short int port;  // host byte order
    int servertype;
    char * scriptdir;
    char const * connectprogram;  // pointer to constant char
    char const * infoprogram;
    // char const * killprogram;
    char const * killconnectprogram;
    char const * killinfoprogram;
    char const * logident;  // used elsewhere than log to identify if demo
    char const * inetdident;
    char * execconnect;
    char * execinfo;
    // char * execkill;
    char * execkillconnect;
    char * execkillinfo;
    char * datadir;    // may be invalid if datafile specified on command line
    char const * conffile;  // may be invalid if datafile specified on command line
    char * conf;
    struct timeval selecttimeout;
} PARAMS2;




#define ISPSHORTNAMELEN 20
#define ISPLONGNAMELEN 50
#define CONFDATALEN 256 // for reading a line from the data file
#define FILENAMELEN 256 // for holding the path/name of a file

typedef struct miceisp {
    char shortname[ISPSHORTNAMELEN + 1];
    char longname[ISPLONGNAMELEN + 1];
    struct miceisp * next;
} MICEISP;




// extern PARAMS * Paramsp;  // real or demo server
extern PARAMS2 * Params2p;  // real or demo server


void switch_off_stdout(void);
void switch_off_stderr(void);
void switch_off_stdin(void);
int check_exec_access(void);
// int check_exec_access_2(char *prog);
int check_exec_access_2(char const *prog);
int check_read_access_2(char const *filename);
MICEISP const *getisps(void);
MICEISP * set_current_isp(char * shortname_p);
MICEISP * get_current_isp(void);
int rereadisps(int action);
void showisps(void);
char * readscriptdir(const char * datafile);
void sigusr1_handler(int s);

int getayt(void);
int rereadayt(int action);

